<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Referral.aspx.cs" Inherits="Referral" MasterPageFile ="~/Registry.master" MaintainScrollPositionOnPostback = "true" %>

<%@ Import   Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href ="styles/StyleSheet.css"/>          
   <script type="text/javascript">
        function checkBoxListOnClick(elementRef, textBoxRef, innerText) {

            textBoxRef.disabled = true;
            textBoxRef.value = "";

            var checkBoxArray = elementRef.getElementsByTagName('input');

            for (var i = 0; i < checkBoxArray.length; i++) {
                var checkBoxRef = checkBoxArray[i];

                if (checkBoxRef.checked == true) {
                    var labelArray = checkBoxRef.parentNode.getElementsByTagName('label');

                    if ((labelArray.length > 0) && (labelArray[0].innerHTML == innerText)) {
                        
                        textBoxRef.disabled = false;
                        textBoxRef.focus();

                        break;
                    }
                }
            }
            return true;
        }

        function clearOtherCheckboxes(chk) {
        
            var chkList = chk.parentNode.parentNode.parentNode;

            var chks = chkList.getElementsByTagName("input");

            for (var i = 0; i < chks.length; i++) {

                if (chks[i] != chk && chk.checked) {

                    chks[i].checked = false;
                }
            }
        }

        function clearInjuryTypeCheckboxes(chk) {
            var BIchk = document.getElementById('ctl00_ContentPlaceHolder_CheckBoxListHealthFactors9_0');
            var NBIchk = document.getElementById('ctl00_ContentPlaceHolder_CheckBoxListHealthFactors9_1');
            var BEIchk = document.getElementById('ctl00_ContentPlaceHolder_CheckBoxListHealthFactors9_2');
            var NBEIchk = document.getElementById('ctl00_ContentPlaceHolder_CheckBoxListHealthFactors9_3');

            if (chk == BIchk && chk.checked == true) {
                // Bullet Injury
                NBIchk.checked = false;
            }
            else if (chk == NBIchk && chk.checked == true) {
                // No Bullet Injury
                BIchk.checked = false;
            }
            else if (chk == BEIchk && chk.checked == true) {
                // Blast Explosion Injury
                NBEIchk.checked = false;
            }
            else if (chk == NBEIchk && chk.checked == true) {
                // Blast Explosion Injury
                BEIchk.checked = false;
            }
        }

        function checkBoxListFragmentsOnClick(chk) {
            
            clearOtherCheckboxes(chk)

            // Clear out the Embedded Fragments Present text box for any click. Enable it and
            // set focus if the Embedded Fragments Present checkbox is selected
            
            var EFRBox = document.getElementById('<%= EFRPresentBox.ClientID %>');
            EFRBox.disabled = true;
            EFRBox.value = "";

            if (chk == document.getElementById("ctl00_ContentPlaceHolder_CheckBoxListHealthFactors1_0") && chk.checked) {

                EFRBox.disabled = false;
                EFRBox.focus();
            }
        }

        function checkBoxListBlastExplTypeOnClick(chk) {

            var OtherBox = document.getElementById('<%= BlastSourceOtherBox.ClientID %>');
            OtherBox.disabled = true;
            OtherBox.value = "";

            if (chk == document.getElementById("ctl00_ContentPlaceHolder_CheckBoxListHealthFactors3_7") && chk.checked) {

                OtherBox.disabled = false;
                OtherBox.focus();
            }
        }

        function checkBoxListUnableToScreenOnClick(chk) {
 
            var AcuteIllnessBox = document.getElementById('<%= AcuteIllnessBox.ClientID %>');
            
            var CognitiveImpairmentBox = document.getElementById('<%= CognitiveImpairmentBox.ClientID %>');
           

            if (chk == document.getElementById("ctl00_ContentPlaceHolder_CheckBoxListHealthFactors10_0") && chk.checked) {

                AcuteIllnessBox.disabled = false;
                AcuteIllnessBox.focus();
            }
            else if (chk == document.getElementById("ctl00_ContentPlaceHolder_CheckBoxListHealthFactors10_0") && !chk.checked) {

                AcuteIllnessBox.disabled = true;
                AcuteIllnessBox.value = "";
            }            

            if (chk == document.getElementById("ctl00_ContentPlaceHolder_CheckBoxListHealthFactors10_1") && chk.checked) {

                CognitiveImpairmentBox.disabled = false;
                CognitiveImpairmentBox.focus();
            }
            else if (chk == document.getElementById("ctl00_ContentPlaceHolder_CheckBoxListHealthFactors10_1") && !chk.checked) {

                CognitiveImpairmentBox.disabled = true; 
                CognitiveImpairmentBox.value = "";
            }
        }
   
</script> 

    <style type="text/css">
        .CheckBoxTester tr td label
        {
            white-space:nowrap;
            overflow:hidden;
              
        }
    </style> 
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID = "ContentPlaceHolder" Runat="Server" >

    <script src="scripts/jquery-1[1].3.2.js" type="text/javascript"></script>
    <script src="scripts/jquery.json-2.2.js" type="text/javascript"></script>
   
    <script type = "text/javascript">

        function ConfirmPush() {
            return confirm('You are about to update the working referral with the data from this duplicate referral. Do you wish to proceed?');
        }

        $(document).ready(function() {

            $('#<%= WorkflowType.ClientID %>').attr('disabled', 'disabled');
            $('#<%= WorkflowType.ClientID %> input:checkbox').attr('disabled', 'disabled');

            $('input[name*=Workflow]:radio').attr('checked', false);
            $('#<%= TextIneligibleReason.ClientID %>').attr('disabled', 'disabled');
            $('#<%= TextIneligibleReason.ClientID %>').val('');

            $('span.redLabel').css({ "color": "#ff0000", "font-size": "large" });

            $('input[name*=Workflow]:radio').click(function() {

                switch ($('input[name*=Workflow]:radio').index($(this))) {
                    case 0:

                        $('#<%= WorkflowType.ClientID %>').removeAttr('disabled');
                        $('#<%= WorkflowType.ClientID %> input:checkbox').removeAttr('disabled');

                        $('#<%= TextIneligibleReason.ClientID %>').attr('disabled', 'disabled');
                        $('#<%= TextIneligibleReason.ClientID %>').val('');

                        ValidatorEnable($("[id*=IneligibleReasonValidator]")[0], false);
                        var validator = $("[id*=IneligibleReasonValidator]")[0];
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);

                        break;

                    case 1:

                        $('#<%= WorkflowType.ClientID %> input:checkbox').attr('checked', false);
                        $('#<%= WorkflowType.ClientID %>').attr('disabled', 'disabled');
                        $('#<%= WorkflowType.ClientID %> input:checkbox').attr('disabled', 'disabled');

                        $('#<%= TextIneligibleReason.ClientID %>').attr('disabled', 'disabled');
                        $('#<%= TextIneligibleReason.ClientID %>').val('');


                        ValidatorEnable($("[id*=IneligibleReasonValidator]")[0], false);
                        var validator = $("[id*=IneligibleReasonValidator]")[0];
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);

                        break;

                    case 2:

                        $('#<%= WorkflowType.ClientID %> input:checkbox').attr('checked', false);
                        $('#<%= WorkflowType.ClientID %>').attr('disabled', 'disabled');
                        $('#<%= WorkflowType.ClientID %> input:checkbox').attr('disabled', 'disabled');

                        $('#<%= TextIneligibleReason.ClientID %>').removeAttr('disabled');

                        //enable reason validator

                        ValidatorEnable($("[id*=IneligibleReasonValidator]")[0], true);
                        var validator = $("[id*=IneligibleReasonValidator]")[0];
                        validator.isvalid = true;
                        ValidatorUpdateDisplay(validator);

                        break;

                }

            });



            if ($('#<%= gridViewSelectField.ClientID %>').val() == '1') {

                $('select.addWorkflow:first').focus();
                $('#<%= gridViewSelectField.ClientID %>').val('0');
            }

            $('span.invisibleAccess').each(function() {
                var l = $("<label class='invisibleAccess' />")
               .html($(this).html())
                //.attr('for', $(this).next(":input").attr("id"));
                .attr('for', $(this).next(':input').attr('id'));
                $(this).replaceWith(l);
                //$(this).css({ "width": "0", "height": "0", "overflow": "hidden", "position": "absolute" });

            });

            $('label.invisibleAccess').css({ "width": "0", "height": "0", "overflow": "hidden", "position": "absolute" });


            if ($('#<%= DuplicateHealthfactorIndicator.ClientID %>').val() == '1') {

                alert('Warning: this referral has duplicate health factors that are not being displayed');

            }

            $('select.facility').change(function() {

                if ($(this).val() == 0) {
                    $('#<%= VAMCAddress1Box.ClientID %>').val("");
                    $('#<%= VAMCAddress2Box.ClientID %>').val("");
                    $('#<%= VAMCAddress3Box.ClientID %>').val("");
                    $('#<%= VAMCAddressCity.ClientID %>').val("");
                    $('#<%= VAMCAddressState.ClientID %>').val("");
                    $('#<%= VAMCAddressPostal.ClientID %>').val("");
                    $('#<%= VAMCAddressCountry.ClientID %>').val("");
                    return;
                } 

                var params = new Object();
                params.vamcId = $(this).val();

                $.ajax(
                {
                    type: "POST",
                    data: $.toJSON(params),
                    dataType: "json",
                    contentType: "application/json",
                    url: "VAMCInformation.asmx/GetVAMCInformation",
                    success: function(response) {
                        $('#<%= VAMCAddress1Box.ClientID %>').val(response.d.Address1);
                        $('#<%= VAMCAddress2Box.ClientID %>').val(response.d.Address2);
                        $('#<%= VAMCAddress3Box.ClientID %>').val(response.d.Address3);
                        $('#<%= VAMCAddressCity.ClientID %>').val(response.d.City);
                        $('#<%= VAMCAddressState.ClientID %>').val(response.d.State);
                        $('#<%= VAMCAddressPostal.ClientID %>').val(response.d.EntireZip);
                        $('#<%= VAMCAddressCountry.ClientID %>').val(response.d.Country);
                    }
                });
            });
        });
        
</script> 
    <asp:ValidationSummary ID="ValidationSummaryReferral" runat="server" 
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="WorkflowsAndIneligible"
        ShowMessageBox="True" />
    <asp:ObjectDataSource ID="ObjectDataSourceReferralStatus" runat="server" 
            SelectMethod="getReferralStatusByReferralID" 
            TypeName="VeteransAffairs.Registries.BusinessManager.ReferralManager">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "referralId" Direction = "Input" Name = "id" /> 
            </SelectParameters> 
     </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
            SelectMethod="GetPatient" 
            TypeName="VeteransAffairs.Registries.BusinessManager.ReferralManager">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "referralId" Direction = "Input" Name = "referralId" /> 
                <asp:QueryStringParameter QueryStringField = "patientId" Direction = "Input" Name = "patientId" /> 
            </SelectParameters>       
     </asp:ObjectDataSource>   
    <asp:ObjectDataSource ID = "ObjectDataSourceReferrals" runat = "server" 
        SelectMethod = "GetWorkflowsByReferralId"
        TypeName = "VeteransAffairs.Registries.BusinessManager.WorkflowManager"
        SelectCountMethod="GetWorkflowsByReferralIdCount"  
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SortParameterName="sort"
        EnablePaging="True"   >
        <SelectParameters>
            <asp:QueryStringParameter QueryStringField = "referralId" Direction = "Input" Name = "id" /> 
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID = "ObjectDataSourceBioFollowUps" runat = "server" 
        SelectMethod = "SelectBioFollowUpsByReferralId"
        TypeName = "VeteransAffairs.Registries.BusinessManager.WorkflowCaseManager">        
        <SelectParameters>
            <asp:QueryStringParameter QueryStringField = "referralId" Direction = "Input" Name = "id" /> 
        </SelectParameters>
    </asp:ObjectDataSource>
    
      
    <div class="breadcrumb">
        <asp:FormView ID="FormViewBreadCrumb" runat="server" DataSourceID="ObjectDataSourceReferralStatus">
            <ItemTemplate>
              <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server" Text='<%# "My Tasks > Referrals > " + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NAME")), false) + " > Referral # " + AntiXssEncoder.HtmlEncode(Request.QueryString["referralId"], false) %>'  />
              <br />
             
            </ItemTemplate>
        </asp:FormView>
    </div>
    
    <asp:Repeater ID = "BioFollowUpsRepeater" runat = "server"  
        DataSourceID = "ObjectDataSourceBioFollowUps"  
        OnItemCommand = "BioFollowUpsRepeater_ItemCommand">
    
        <HeaderTemplate>
        <table id="TableFollowUps" cellspacing="-2" cellpadding="2">
            
        </HeaderTemplate> 
    
        <SeparatorTemplate>
            <tr>
                <td colspan="2">
                    &nbsp; 
                </td>
            </tr>
        </SeparatorTemplate> 
        
        <ItemTemplate>
            <tr>
                <td colspan = "2">
                    
                    <asp:HiddenField ID="CaseActivityIDField" runat="server" 
                        Value='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseActivityId")), false) %>' />
                    <asp:Label SkinID="DataLabel" ID = "LabelBioFollowupDueDate" runat = "server" 
                        CssClass = "redLabel" Text = '<%# "Needs Follow Up Biomonitoring, due" + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("DueDate")), false) %>'></asp:Label>     
                </td>
                            
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp; 
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Button ID = "ButtonCreateBioFollowup" runat = "server" Text = "Create Follow Up Biomonitoring Workflow" CommandName = "Create" />
                </td>
                <td>
                    <asp:Button ID = "ButtonDeclineBioFollowup" 
                        runat = "server" 
                        Text = "Decline Follow Up Biomonitoring" 
                        CommandName = "Decline" 
                        OnClientClick="return confirm('Are you sure you want to decline this follow up?');" />             
                </td>           
            </tr>
        </ItemTemplate> 
         
        <FooterTemplate>
            <tr>
                <td colspan="2">
                    &nbsp; 
                </td>
            </tr>
            
        </table> 
        </FooterTemplate>
    
    </asp:Repeater> 
    
    <asp:HiddenField ID = "DuplicateHealthfactorIndicator" runat = "server" />
    
    <table>
        <tr>
            <td>
            <asp:FormView ID="FormViewPatientInformation" runat="server"  
            DataSourceID="ObjectDataSourcePatient" Width="100%" DataKeyNames = "PATIENT_ID">
                <ItemTemplate>
                    
                    <asp:Panel ID="PanelPatient" runat="server" GroupingText="Patient" Width="100%">
                    
                    <table cellpadding="-1" cellspacing="-1" width="100%">
                        <tr style = "height:20px;" >
                            <td style="width:20px;">
                                
                            </td>
                            <td>
                                <asp:Label ID="LabelICN" runat="server" Text="ICN:" AssociatedControlID="VPIDLabel" SkinID = "DataLabel"></asp:Label>
                                <asp:Label ID="VPIDLabel" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PATIENT_ICN")), false) %>' SkinID = "DataLabel" />
                            </td>
                            <td>
                                <asp:Label ID="LabelName" runat="server" Text="Name:" AssociatedControlID="PatientWorkflowsLink" SkinID = "DataLabel"></asp:Label>
                                <asp:Label ID="NameLabel" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAST_NAME")), false) + "," + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("FIRST_NAME")), false) + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("MIDDLE_NAME")), false)%>' />
                                <asp:HyperLink runat="server" Text= '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAST_NAME")), false) + "," + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("FIRST_NAME")), false) + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("MIDDLE_NAME")), false)%>' NavigateUrl = '<%# "~/PatientWorkflows.aspx?patientId=" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PATIENT_ID")), false)%>' ID= "PatientWorkflowsLink" ></asp:HyperLink>
                            
                            </td>
                            <td>
                                <asp:Label ID="LabelZip" runat="server" Text="Zip:" AssociatedControlID="ZipLabel" SkinID = "DataLabel"></asp:Label>
                                <asp:Label ID="ZipLabel" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("POSTAL_CODE")), false) %>' SkinID = "DataLabel" />
                            </td>
                            
                            <td >
                                <asp:Label ID="LabelForSSN" runat="server" Text="SSN:" AssociatedControlID="LabelSSN" SkinID = "DataLabel"></asp:Label>
                                <asp:Label ID = "LabelSSN" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Snum")), false) %>' SkinID = "DataLabel"  />
                            </td>
                            <td>
                                &nbsp;
                            </td>
                           
                            <td>
                                <asp:Label ID="LabelForDOB" runat="server" Text="DOB:" AssociatedControlID="LabelDOB" SkinID = "DataLabel"></asp:Label>
                                <asp:Label ID = "LabelDOB" runat = "server"  Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("BIRTH_DATE", "{0:d}")), false) %>' SkinID = "DataLabel"/> 
                            </td>
                        </tr>
                        <tr style = "height:20px;" >
                             <td style="width:20px;">
                            </td>
                            <td>
                                <asp:Label ID="Labelfor" runat="server" Text="OEF/OIF Indicator:" AssociatedControlID="LabelOefOifIndicator" SkinID = "DataLabel"></asp:Label>
                                <asp:Label ID="LabelOefOifIndicator" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("OefOifIndicator")), false) %>' SkinID = "DataLabel" />
                            </td>
                            <td>
                                <asp:CheckBox
                                    ID="CheckBoxIraqAfghanService" runat="server" 
                                    Enabled="false" Text="Iraq/Afghan Service" />
                            </td>
                             <td colspan="4">
                                <asp:Label ID="LabelforLabelServiceSeparationDate" runat="server" Text="Service Separation Date:" AssociatedControlID="LabelServiceSeparationDate" SkinID = "DataLabel"></asp:Label>
                                <asp:Label ID="LabelServiceSeparationDate" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ServiceSeparationDate")), false) %>' SkinID = "DataLabel" />
                            </td>
                      </tr> 
                    </table>
                </asp:Panel>   
            </ItemTemplate>
            </asp:FormView>
            </td> 
        </tr>
        <tr>
            <td>
                
                <asp:Panel ID="PanelReferralDuplicate" runat="server" Visible= "false" BorderStyle="Dotted" BorderColor="Red">
                 
                   <table width="100%">
                   
                        <tr>
                            <td>
                                &nbsp;&nbsp;&nbsp;&nbsp;<strong><font color="red"><asp:Label SkinID="DataLabel" ID="LabelDuplicateHeader" runat="server"></asp:Label></font></strong><br /><br />
                            </td>
                            
                        </tr>
                        <tr>
                            <td>
                                &nbsp;&nbsp;&nbsp;&nbsp;<asp:Label SkinID="DataLabel" ID = "DuplicateWording" runat = "server" />   
                            </td>
                            
                        </tr>
                        <tr>
                            <td>
                                <br />
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                    <asp:HyperLink ID="DuplicateOriginalLink" runat="server" ></asp:HyperLink>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <asp:Button ID = "btnPushData" Text = "Copy to Working Referral" runat = "server" 
                                                OnClick = "btnPushData_Click" OnClientClick="return ConfirmPush();"
                                                Enabled = "true" Width = "180" Visible="false"/> 
                                    <asp:HiddenField ID = "WorkingRefId" runat = "server" Value = "0" />
                                <br /><br />
                            
                            </td>
                                  
                        </tr> 
                    </table> 
                </asp:Panel>
                
            </td>
        </tr>
        <tr>
            <td>
            <asp:Panel ID="PanelDetails" runat="server" GroupingText=" Referral Details " Width="100%">
                <br />
                
                 <asp:Panel ID = "PanelReferral" runat = "server" Width = "100%" BorderWidth = "0px">  
                 
                    <table cellpadding="-1" cellspacing="-1" width="100%">
                        <tr style = "height:20px;" >
                            <td >
                                &nbsp;
                            </td>
                            <td>
                                
                                <asp:Label ID = "ReferralDateLabel" runat = "server" SkinID = "DataLabel" AssociatedControlID = "LabelReferralDate" Text = "Referral Date:"/>
                                <asp:Label ID = "LabelReferralDate" runat = "server" SkinID = "DataLabel"></asp:Label>  
                            </td>
                             <td>
                            &nbsp;
                                
                                <asp:Label ID = "LabelforLabelCreatedBy" runat = "server" 
                                    SkinID = "DataLabel" 
                                    AssociatedControlID = "LabelCreatedBy" 
                                    Text = "Created By:"/>
                                <asp:Label ID= "LabelCreatedBy" runat = "server" SkinID = "DataLabel"/>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            
                            <td>
                                &nbsp;
                                <asp:HyperLink ID="hlOriginalReferral" runat="server" Visible="false">View Original Referral</asp:HyperLink>
                            </td>
                           </tr>
                            <tr>
                            <td >
                                &nbsp;
                            </td>
                           <td>
                                <asp:Label ID = "TEFSCDateForLabel" runat = "server" 
                                    SkinID = "DataLabel" 
                                    AssociatedControlID = "TEFSCDateLabel" 
                                    Text = "Date Sent to TEFSC:"/>
                                <asp:Label ID= "TEFSCDateLabel" runat = "server" SkinID = "DataLabel"/>
                            </td>
                            <td >
                            &nbsp;
                                
                                <asp:Label ID = "ReviewedDateLabel" SkinID = "DataLabel" runat = "server" AssociatedControlID = "ReviewedDateBox" Text = "Reviewed Date:"/>
                                <asp:Label ID = "ReviewedDateBox" runat = "server" SkinID = "DataLabel" />                   
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            
                            <td>
                                &nbsp;
                                <asp:Label ID = "ReviewedByLabel" runat = "server" SkinID = "DataLabel" AssociatedControlID = "ReviewedByBox" Text = "Reviewed By:"/>
                                <asp:Label ID = "ReviewedByBox" runat = "server" SkinID = "DataLabel" />
                            </td>
                        </tr>
                    </table>
                </asp:Panel>      
                <br />
                <asp:Panel ID="PanelReminder" runat="server" GroupingText= " Risk Category " Width = "100%" >
                <table width = "100%" border = "0px">
                    
                     <tr  >
                        <td align = "left">
                            <asp:Label ID = "LabelClinicalReminder" runat = "server" 
                                SkinID = "DataLabel" />
                         </td>         
                     </tr>    
                </table>
                </asp:Panel>  
                <br /> 
               <asp:Panel ID="PanelVAMC" runat="server" GroupingText=" Veterans Affairs Medical Center " Width = "100%">
                <table width = "100%" border = "0px">
                    <tr >
                    <td align = "left">
                        <table border = "0px">       
                            <tr style = "height:20px;">  
                                <td>   
                                <asp:Label SkinID="DataLabel" ID = "VAMCFAcilityNamesListLabel" runat = "server" 
                                    AssociatedControlID = "VAMCFAcilityNamesListBox" 
                                    Text = "Facility Name:"/>
                                </td>
                                <td>
                                <asp:DropDownList ID="VAMCFAcilityNamesListBox"  runat="server" 
                                   CssClass = "facility" Width="450px"/>
                               <asp:CustomValidator ID="CustomValidatorVAMC" runat="server" Display="Dynamic"
                                ErrorMessage="Facility Name is required." 
                                ControlToValidate="VAMCFAcilityNamesListBox"
                                ClientValidationFunction="ValidateDropDown"
                                ValidationGroup="WorkflowsAndIneligible" 
                                EnableClientScript= "true"   EnableViewState="false"
                                SetFocusOnError= "true" Enabled="true"/>
                               </td>    
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left">   
                                    <asp:Label SkinID="DataLabel" ID = "VAMCAddress1Label" runat = "server" AssociatedControlID = "VAMCAddress1Box" Text = "Address 1:"/>
                               </td>
                                <td>
                                    <asp:TextBox ID = "VAMCAddress1Box" runat = "server" 
                                    Width = "300px" />
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left">   
                                    <asp:Label SkinID="DataLabel" ID = "LabelVAMCAddress2Box" runat = "server" AssociatedControlID = "VAMCAddress2Box" Text = "Address 2:"/>
                               </td>
                                <td>
                                    <asp:TextBox ID = "VAMCAddress2Box" runat = "server"
                                    Width = "300px" />
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left" >   
                                    <asp:Label SkinID="DataLabel" ID = "Label1" runat = "server" AssociatedControlID = "VAMCAddress3Box" Text = "Address 3:"/>
                               </td>
                                <td>
                                    <asp:TextBox ID = "VAMCAddress3Box" runat = "server"
                                    Width = "300px" />
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;" >
                                <td align = "left" >   
                                    <asp:Label SkinID="DataLabel" ID = "LabelVAMCAddressCity" runat = "server" AssociatedControlID = "VAMCAddressCity" Text = "City:"/>
                                </td>
                                <td>
                                    <asp:TextBox ID = "VAMCAddressCity" runat = "server" />&nbsp;
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left" >   
                                    <asp:Label SkinID="DataLabel" ID = "LabelVAMCAddressState" runat = "server" AssociatedControlID = "VAMCAddressState" Text = "State:"/>
                                </td>
                                <td>
                                    <asp:TextBox ID = "VAMCAddressState" runat = "server" 
                                    Width = "50px" />&nbsp;
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left" >
                                    <asp:Label SkinID="DataLabel" ID = "LabelVAMCAddressPostal" runat = "server" AssociatedControlID = "VAMCAddressPostal" Text = "Zip/Postal:"/>
                                </td>
                                <td>
                                    <asp:TextBox ID = "VAMCAddressPostal" runat = "server" />
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left" >   
                                    <asp:Label SkinID="DataLabel" ID = "VAMCAddressCountryLabel" runat = "server" AssociatedControlID = "VAMCAddressCountry" Text = "Country:"/>
                               </td>
                                <td>
                                    <asp:TextBox ID = "VAMCAddressCountry" runat = "server" 
                                    Width = "300px" />
                                </td>                      
                            </tr> 
                        </table> 
                    </td>
                    <td align = "left">
                          <table border = "0px">       
                          
                          <tr style = "height:20px;">  
                              <td align = "left" >
                                    
                                    <asp:Label SkinID="DataLabel" ID = "VAMCContactNameLabel" runat = "server" AssociatedControlID = "VAMCContactName" Text = "Contact Name:"/>
                              </td>
                              <td>
                                    <asp:TextBox ID = "VAMCContactName" MaxLength="255" runat = "server" />
                              
                              </td> 
                          </tr>
                           
                          <tr style = "height:20px;">
                          <td align = "left" > 
                                
                                
                                <asp:Label SkinID="DataLabel" ID = "VAMCContactEMailLabel" runat = "server" AssociatedControlID = "VAMCContactEMail" Text = "Contact Email:"/>
                          </td>     
                          <td>
                                <asp:TextBox ID = "VAMCContactEMail" runat = "server" 
                                MaxLength="255" CssClass = "emailfield" />
                                <span class = "ValidatorClass" style = "color:Red;display:none">Contact Email is not a valid e-mail.</span>     
                                
                           </td>
                           </tr> 
                            <tr style = "height:20px;">
                            
                            <td align = "left" > 
                                <asp:Label SkinID="DataLabel" ID = "VAMCContactPhoneLabel" runat = "server" 
                                    AssociatedControlID = "VAMCContactPhone" 
                                    Text = "Contact Phone:"/>
                            </td>
                            <td>
                                <asp:TextBox ID = "VAMCContactPhone" runat = "server" 
                                CssClass = "phonefield" MaxLength="255" />
                                <span class = "ValidatorClass" style = "color:Red;display:none">Phone field can only contain numbers and the following characters: + - ( ) x.</span>
                                
                                
                            </td>
                            </tr> 
                            <tr style = "height:20px;">
                            <td align = "left" >     
                                
                                <asp:Label SkinID="DataLabel" ID = "VAMCContactFAXLabel" runat = "server" 
                                    AssociatedControlID = "VAMCContactFAX" 
                                    Text = "Contact FAX:"/>
                            </td>
                            <td>
                                <asp:TextBox ID = "VAMCContactFAX" runat = "server" 
                                MaxLength="255" CssClass = "phonefield" />
                                <span class = "ValidatorClass" style = "color:Red;display:none">Fax field can only contain numbers and the following characters: + - ( ) x.</span>
                                
                            </td>
                           </tr> 
                           </table>                           
                     </td>
                    </tr>
                </table> 
                </asp:Panel>
                
                <br />
                <asp:Panel ID="PanelPCP" runat="server" GroupingText=" Primary Care Physician " Width = "100%" >
                    <br />
                    <table cellpadding="-1" cellspacing="-1" width="100%">
                    <tr >
                        <td align= "left"> 
                         <table border = "0px">
                            <tr style = "height:20px;" >
                                <td align = "left" >
                                    &nbsp;
                                    <asp:Label SkinID="DataLabel" ID = "PCPNameLabel" runat = "server" AssociatedControlID = "PCPName" Text = "Name:"/>
                                </td>
                                <td> 
                                    <asp:TextBox ID = "PCPName" runat = "server"/>
                                </td>
                            </tr>
                            <tr style = "height:20px;" >
                                <td align = "left" >
                            
                                    &nbsp;
                                    <asp:Label SkinID="DataLabel" ID = "PCPPhoneLabel" runat = "server" AssociatedControlID = "PCPPhone" Text = "Phone:"/>
                                </td>
                                <td> 
                                    <asp:TextBox ID = "PCPPhone" runat = "server" CssClass = "phonefield"/>
                                    <span class = "ValidatorClass" style = "color:Red;display:none">Phone field can only contain numbers and the following characters: + - ( ) x.</span>
                                </td> 
                             </tr>   
                             <tr style = "height:20px;" >
                                <td align = "left" >   
                                    &nbsp;
                                    <asp:Label SkinID="DataLabel" ID = "PCPEMailLabel" runat = "server" AssociatedControlID = "PCPEMail" Text = "Email:"/>
                                </td> 
                                <td>
                                    <asp:TextBox ID = "PCPEMail" runat = "server" CssClass = "emailfield"/>
                                    <br />
                                    <span class = "ValidatorClass" style = "color:Red;display:none">PCP Email is not a valid e-mail</span>
                                </td>
                              </tr>
                              <tr style = "height:20px;" >
                                <td align = "left" >   
                                    &nbsp;
                                    <asp:Label SkinID="DataLabel" ID = "PCPFaxLabel" runat = "server" AssociatedControlID = "PCPFax" Text = "FAX Number:"/>
                                </td> 
                                <td>
                                    <asp:TextBox ID = "PCPFax" runat = "server" CssClass = "phonefield"/>
                                    <br />
                                    <span class = "ValidatorClass" style = "color:Red;display:none">Fax field can only contain numbers and the following characters: + - ( ) x.</span>
                                    
                                </td>
                              </tr> 
                              </table> 
                           </td>
                           <td>
                           <table border = "0px">
                                <tr style = "height:20px;" >
                                    <td>
                                        <asp:Label SkinID="DataLabel" ID = "PCPAddress1Label" runat = "server" AssociatedControlID = "PCPAddress1" Text = "Address 1:"/>
                                    </td>
                                    <td> 
                                        <asp:TextBox ID = "PCPAddress1" runat = "server"/>
                                    </td>
                                </tr>
                                <tr style = "height:20px;" >
                                    <td>
                                        <asp:Label SkinID="DataLabel" ID = "PCPAddress2Label" runat = "server" AssociatedControlID = "PCPAddress2" Text = "Address 2:"/>
                                    </td>
                                    <td> 
                                        <asp:TextBox ID = "PCPAddress2" runat = "server"/>
                                    </td>
                                </tr>
                                <tr style = "height:20px;" >
                                    <td>
                                        <asp:Label SkinID="DataLabel" ID = "PCPAddress3Label" runat = "server" AssociatedControlID = "PCPAddress3" Text = "Address 3:"/>
                                    </td>
                                    <td> 
                                        <asp:TextBox ID = "PCPAddress3" runat = "server"/>
                                    </td>
                                </tr>
                            <tr style = "height:20px;" >
                                <td align = "left" >   
                                        <asp:Label SkinID="DataLabel" ID = "LabelPCPCity" runat = "server" AssociatedControlID = "PCPCity" Text = "City:"/>
                                </td>
                                <td>
                                        <asp:TextBox ID = "PCPCity" runat = "server"/>&nbsp;
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left" >   
                                        <asp:Label SkinID="DataLabel" ID = "LabelPCPState" runat = "server" AssociatedControlID = "PCPState" Text = "State:"/>
                                </td>
                                <td>
                                        <asp:TextBox ID = "PCPState" runat = "server" Width = "50px"/>&nbsp;
                                </td>                      
                            </tr> 
                            <tr style = "height:20px;">
                                <td align = "left" >
                                        <asp:Label SkinID="DataLabel" ID = "LabelPCPPostal" runat = "server" AssociatedControlID = "PCPPostal" Text = "Zip/Postal:"/>
                                </td>
                                <td>
                                        <asp:TextBox ID = "PCPPostal" runat = "server"/>
                                </td>                      
                            </tr> 
                                <tr style = "height:20px;" >
                                    <td>
                                        <asp:Label SkinID="DataLabel" ID = "PCPCountryLabel" runat = "server" AssociatedControlID = "PCPCountry" Text = "Country:"/>
                                    </td>
                                    <td> 
                                        <asp:TextBox ID = "PCPCountry" runat = "server"/>
                                    </td>
                                </tr>
                            </table> 
                           </td>
                       </tr>   
                       </table>  
                </asp:Panel>
                
                <br />
            </asp:Panel>
            </td>
        </tr>
        <tr>
            <td>
                <asp:Panel ID="PanelHealthfactors" runat="server" 
                    GroupingText="&nbsp;Health Factors&nbsp;" Visible = "true" Width = "100%" 
                    CssClass="divCell" Height="618px" >
                <div style="height: 608px">
                <table border="0" width="100%">
                    <tr>
                        <td width="33%">
                            <asp:Panel runat="server" id="FragmentPanel" GroupingText="&nbsp;Fragments&nbsp;" Width="95%" >
                                <table border="0">
                                <tr>
                                <td align = "left"> 
                                    <asp:CheckBoxList  ID="CheckBoxListHealthFactors1" runat="server" >
                                        <asp:ListItem Value="69" onclick="checkBoxListFragmentsOnClick(this)">Embedded Fragments Present</asp:ListItem>
                                        <asp:ListItem Value="70" onclick="checkBoxListFragmentsOnClick(this)">No Embedded Fragments</asp:ListItem>
                                        
                                    </asp:CheckBoxList>
                                <%--<asp:CustomValidator ID="HealthFactorValidator" runat="server" Display="Dynamic"
                                ErrorMessage="Only one fragment selection is allowed" 
                                ClientValidationFunction="checkFragmentListValidate"
                                ValidationGroup = "WorkflowsAndIneligible" EnableClientScript= "true" SetFocusOnError= "true" Width = "100%" />--%>   
                                    <span class = "ValidatorClass" style = "color:Red;display:none">Only one fragment selection is allowed</span>
                                
                                </td>
                                <td>
                                    <asp:TextBox ID="EFRPresentBox" runat= "server" 
                                        Width="100px" 
                                        Enabled = "false" 
                                        ToolTip="Enter body parts where Embedded Fragments are present.">
                                    </asp:TextBox>   
                                </td>
                                </tr>
                                </table>
                            </asp:Panel> 
                        </td>
                        <td width="33%">     
                            <asp:Panel runat="server" id="PanelInjuryType" GroupingText="&nbsp;Injury Type&nbsp;" Width="95%">
                                <asp:CheckBoxList  ID="CheckBoxListHealthFactors9" runat="server">
                                    <asp:ListItem Value="4" onclick="clearInjuryTypeCheckboxes(this)">Bullet Injury</asp:ListItem>
                                    <asp:ListItem Value="21" onclick="clearInjuryTypeCheckboxes(this)">No Bullet Injury</asp:ListItem>
                                    <asp:ListItem Value="3" onclick="clearInjuryTypeCheckboxes(this)">Blast/Explosion Injury</asp:ListItem>
                                    <asp:ListItem Value="20" onclick="clearInjuryTypeCheckboxes(this)">No Blast/Explosion Injury</asp:ListItem>
                                </asp:CheckBoxList>
                                </asp:Panel>
                              
                        </td>
                        <td>
                              <asp:Panel runat="server" id="BlastInformationPanel" 
                                  GroupingText="&nbsp;Blast/Explosion Type&nbsp;" 
                                  Width="99%" 
                                  CssClass = "CheckBoxTester" >
                                  <table border="0" >
                                    <tr>
                                        <td align = "left"> 
                                    
                                          <asp:CheckBoxList  ID="CheckBoxListHealthFactors3" runat="server" >
                                              <asp:ListItem Value="17">IED</asp:ListItem>
                                              <asp:ListItem Value="26">RPG</asp:ListItem>
                                              <asp:ListItem Value="19">Land Mine</asp:ListItem>
                                              <asp:ListItem Value="16">Grenade</asp:ListItem>
                                              <asp:ListItem Value="8">Enemy Fire</asp:ListItem>
                                              <asp:ListItem Value="15">Friendly Fire</asp:ListItem> 
                                              <asp:ListItem Value="2">Unknown Type</asp:ListItem>
                                              <asp:ListItem Value="1" onclick="checkBoxListBlastExplTypeOnClick(this)">Other</asp:ListItem>
                                          </asp:CheckBoxList>
                                        </td> 
                                        <td align="center">
                                        <table>
                                            <tr style ="height:20px">
                                            <td>
                                                &nbsp; 
                                            </td>
                                            
                                            </tr>
                                            <tr style ="height:20px">
                                            <td>
                                                &nbsp;
                                            </td>
                                            
                                            </tr>
                                            <tr style ="height:20px">
                                            <td>
                                                &nbsp;
                                            </td>
                                            
                                            </tr>
                                            <tr style ="height:20px">
                                            <td>
                                                &nbsp;
                                            </td>
                                            
                                            </tr>
                                            <tr style ="height:20px">
                                            <td>
                                                &nbsp;
                                            </td>
                                            
                                            </tr>
                                            <tr style ="height:20px">
                                            <td>
                                                &nbsp;
                                            </td>
                                            
                                            </tr>
                                            <tr style ="height:20px">
                                            <td>
                                                &nbsp;
                                            </td>
                                            
                                            </tr>
                                            <tr style="height:20px">
                                            <td>
                                                <asp:TextBox ID = "BlastSourceOtherBox" runat= "server" 
                                                    Width="140px" 
                                                    Enabled="false" 
                                                    ToolTip="Enter other Blast/Explosion type.">
                                                </asp:TextBox>
                                            </td> 
                                            </tr>
                                        </table>
                                    </td>
                                    </tr> 
                                    </table> 
                              </asp:Panel>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                             <asp:Panel runat="server" id="FragmentsInBodyPanel" GroupingText="&nbsp;Fragments In Body&nbsp;" Width="95%">
                                      <asp:CheckBoxList  ID="CheckBoxListHealthFactors5" runat="server" CssClass = "mutuallyExclusive">
                                        <asp:ListItem Value="9" onclick="clearOtherCheckboxes(this)">Fragments in Body</asp:ListItem>
                                        <asp:ListItem Value="22" onclick="clearOtherCheckboxes(this)">No Fragments in Body</asp:ListItem>
                                        <asp:ListItem Value="27" onclick="clearOtherCheckboxes(this)">Unknown if Fragments In Body</asp:ListItem>
                                    </asp:CheckBoxList>
                                    
                                </asp:Panel>
                            
                        </td>
                        <td>
                            <asp:Panel runat="server" id="PanelRadioGraphy" GroupingText="&nbsp;Radiography&nbsp;" Width="95%">
                                <asp:CheckBoxList  ID="CheckBoxListHealthFactors4" runat="server" CssClass = "mutuallyExclusive" >
                                    <asp:ListItem Value="12" onclick="clearOtherCheckboxes(this)">Fragments on Radiograph</asp:ListItem>
                                    <asp:ListItem Value="23" onclick="clearOtherCheckboxes(this)">Not Documented on Radiograph</asp:ListItem>
                                    <asp:ListItem Value="28" onclick="clearOtherCheckboxes(this)">Unknown if Fragments on Radiograph</asp:ListItem>
                                </asp:CheckBoxList>
                                
                                </asp:Panel>
                        </td>
                        <td>
                              
                            <asp:Panel runat="server" id="Panel4" GroupingText="&nbsp;Vehicle&nbsp;" Width="95%">
                                <asp:CheckBoxList  ID="CheckBoxListHealthFactors8" runat="server" CssClass = "mutuallyExclusive">
                                    <asp:ListItem Value="18" onclick="clearOtherCheckboxes(this)">In Vehicle</asp:ListItem>
                                    <asp:ListItem Value="24" onclick="clearOtherCheckboxes(this)">Not In Vehicle</asp:ListItem>
                                </asp:CheckBoxList>
                            
                               </asp:Panel>
                                                                                   
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <br />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:Panel runat="server" id="SurgeryPanel" GroupingText="&nbsp;Surgery&nbsp;" Width="95%" >
                                <asp:CheckBoxList  ID="CheckBoxListHealthFactors2" runat="server" CssClass = "mutuallyExclusive">
                                        <asp:ListItem Value="13" onclick="clearOtherCheckboxes(this)">Fragments Removed in Surgery</asp:ListItem>
                                        <asp:ListItem Value="10" onclick="clearOtherCheckboxes(this)">Fragments Not Removed in Surgery</asp:ListItem>
                                        <asp:ListItem Value="29" onclick="clearOtherCheckboxes(this)">Unknown if Removed in Surgery</asp:ListItem>
                                </asp:CheckBoxList>
                                
                                </asp:Panel>
                        </td>
                    
                        <td>
                              <asp:Panel runat="server" id="Panel1" GroupingText="&nbsp;Laboratory&nbsp;" Width="95%">
                                   <asp:CheckBoxList  ID="CheckBoxListHealthFactors7" runat="server" CssClass = "mutuallyExclusive">
                                        <asp:ListItem Value="14" onclick="clearOtherCheckboxes(this)">Fragments Sent To Lab</asp:ListItem>
                                        <asp:ListItem Value="11" onclick="clearOtherCheckboxes(this)">Fragments Not Sent To Lab</asp:ListItem>
                                        <asp:ListItem Value="30" onclick="clearOtherCheckboxes(this)">Unknown if Fragments Sent To Lab</asp:ListItem>
                                    </asp:CheckBoxList>
                                    
                                   </asp:Panel>
                            </td>
                            <td>
                                <asp:Panel runat="server" id="Panel6" GroupingText="&nbsp;Unable to Screen&nbsp;" Width="95%">
                                    <table border="0">
                                        <tr>
                                            <td align = "left" 
                                                style =" width:60%"> 
                                                <asp:CheckBoxList  ID="CheckBoxListHealthFactors10" runat="server" > 
                                                    <asp:ListItem Value="75" onclick="checkBoxListUnableToScreenOnClick(this)" Text="Acute Illness"></asp:ListItem>
                                                    <asp:ListItem Value="79" onclick="checkBoxListUnableToScreenOnClick(this)" Text="Severe Cognitive Impairment"></asp:ListItem>
                                                    <asp:ListItem Value="25" Text="Refused Screening Tool"></asp:ListItem>
                                                </asp:CheckBoxList>
                                            </td>
                                            <td align="left">
                                                <asp:TextBox ID="AcuteIllnessBox" runat = "server" 
                                                    Enabled="false" 
                                                    Width="110px" 
                                                    ToolTip="Enter Acute Illness type." />
                                                <asp:TextBox ID="CognitiveImpairmentBox" runat = "server" 
                                                    Enabled="false"  
                                                    Width="110px" 
                                                    ToolTip="Enter Cognitive Impairment type." />   
                                            </td>
                                        </tr> 
                                    </table> 
                                </asp:Panel> 
                            </td>
                        </tr>                      
                        <tr>
                            <td>
                                <asp:Button ID = "VTADataButton" runat = "server" Text = "View DoD EMFR Related Data" OnClick = "VTADataButton_Click" ValidationGroup = "DoDButton" />                                                      </td>                        
                        </tr>
                        <tr>
                            <td colspan="3">
                                <asp:Label SkinID="DataLabel" ID="LabelDoDFragmentMessage" 
                                runat="server" Font-Bold="true" ></asp:Label>
                                <asp:Label SkinID="DataLabel" ID="LabelDoDFragmentDate" 
                                runat="server" Font-Bold="true" ></asp:Label>
                            </td>
                        </tr>
                    </table>
                </div>
            </asp:Panel>
        </td> 
    </tr>
    <tr>
        <td>
        <asp:Panel ID="PanelWorkflows" runat="server" GroupingText="&nbsp;Workflows&nbsp;" Visible = "false" Width = "100%">
            <asp:HiddenField ID = "gridViewSelectField" runat = "server" Value = "0" />
            <asp:GridView ID = "Workflows" runat ="server" DataSourceID = "ObjectDataSourceReferrals" AutoGenerateColumns = "false"  OnRowCommand="Workflows_RowCommand" 
                AllowSorting = "true" ShowFooter = "true" Visible = "true" DataKeyNames = "wfID" PageSize = "20" AllowPaging = "true"  OnRowDataBound = "Workflows_RowDataBound"   >
               <EmptyDataTemplate>
                    <table>
                        <tr>
                            <td>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                            </td>
                            <td>
                                <asp:Label ID = "WorkflowTypesEmptyListLabel" runat = "server" Text = "Specimen Type" SkinID = "InvisibleGridViewLabel"></asp:Label> 
                                <asp:DropDownList ID="WorkflowTypesEmptyList" runat="server" CssClass = "addWorkflow" 
                                    TabIndex="2">
                                </asp:DropDownList>
                                <asp:RequiredFieldValidator ID="WorkflowSelectionRequiredValidator" runat="server" 
                                    ControlToValidate = "WorkflowTypesEmptyList"  
                                    InitialValue = "0" 
                                    Display="Dynamic" 
                                    ValidationGroup = "Workflows" 
                                    EnableClientScript="true"  
                                    SetFocusOnError="true"
                                    TabIndex="3" 
                                    ErrorMessage="Please Select Specimen Type.">
                                </asp:RequiredFieldValidator> 
                            </td>
                            <td>
                                <asp:Button ID="addEmptyCommand" runat="server" 
                                    CommandName="EMPTYADD" 
                                    Text="Add Workflow"
                                    Width="130px" 
                                    UseSubmitBehavior="false" 
                                    ValidationGroup="Workflows" /> 
                            </td>
                            <td>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                            </td>
                        </tr>    
                    </table>
                </EmptyDataTemplate>
                <Columns>
                    <asp:TemplateField HeaderText = "Workflow ID"  SortExpression="WKF_CASE_ID">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID = "WorkflowID" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("wfID")), false) %>'/>
                        </ItemTemplate>    
                     </asp:TemplateField>
                    <asp:TemplateField HeaderText = "Specimen Type"  SortExpression="STD_WKFCASETYPE.Name">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID = "Types" runat = "server" Text= '<%#AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("wfType")), false)%>'></asp:Label>
                        </ItemTemplate>
                        <FooterTemplate>
                            <asp:Label ID = "WorkflowTypesListLabel" runat = "server" Text = "Specimen Type" SkinID = "InvisibleGridViewLabel"></asp:Label> 
                            <asp:DropDownList ID = "WorkflowTypesList" runat = "server" CssClass = "addWorkflow" 
                                TabIndex="4">
                            </asp:DropDownList> 
                            <asp:RequiredFieldValidator ID="WorkflowSelectionRequiredValidator" runat="server" 
                                ForeColor="Red" 
                                Display="Dynamic" 
                                EnableClientScript="true"  
                                SetFocusOnError="true" 
                                TabIndex="5"
                                ControlToValidate="WorkflowTypesList"  
                                ValidationGroup="Workflows" 
                                InitialValue="0"
                                ErrorMessage="Please Select Specimen Type.">
                            </asp:RequiredFieldValidator> 
                        </FooterTemplate>     
                     </asp:TemplateField>
                     <asp:TemplateField HeaderText = "Workflow Status"  SortExpression="STD_WKFCASEST.NAME">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID = "WorkflowStatus" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("wfStatus")), false) %>'/>
                        </ItemTemplate>
                        <FooterTemplate>
                            <asp:Button ID = "addCommand" runat= "server" 
                                CommandName = "ADD" 
                                Text = "Add Workflow" 
                                Width="130px"
                                ValidationGroup="Workflows" 
                                UseSubmitBehavior = "false"  /> 
                        </FooterTemplate>      
                     </asp:TemplateField>
                     <asp:TemplateField HeaderText = "Last Updated"  SortExpression="UPDATED">
                        <ItemTemplate>
                            <asp:Label SkinID="DataLabel" ID = "WorkflowUpdated" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("wfUpdated")), false) %>'/>
                        </ItemTemplate>
                     </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </asp:Panel>
            </td>
            </tr>
                <tr>
                <td>
            
            <div style= "padding-left:10;padding-top:10;padding-bottom:10;">
            <asp:Panel ID="PanelNoActionIneligible" runat="server" GroupingText=" Triage Status " Width = "100%">
                <div class = "indented">
                       <br />                      
                       <asp:Label SkinID="DataLabel" ID = "IneligibilityReason" runat = "server" Text = "Ineligibility Reason:" Font-Size = "Small" ></asp:Label>
                         
                        <br />
                        <br />
                       <asp:Button ID = "ClearButton" Text = "Clear Triage" runat = "server" OnClick = "ClearButton_Click" Enabled = "true" Width = "100" />
                        <br />
                        <br />
                </div> 
            </asp:Panel>
            </div>  
        </td>
        </tr>
        <tr>
        <td>
            <asp:Panel ID="PanelChecklist" runat="server" GroupingText=" Triage Referral " Width = "100%">
                 
                            <asp:Panel runat = "server" ID = "Outer" BorderStyle = "Solid" BorderWidth = "1px" Width = "100%" Font-Bold = "false">
                            
                                <asp:RadioButton ID = "First" Text = "Accept" GroupName = "Workflow" runat = "server"  
                                 Font-Bold = "false" Checked = "false" />  

                                <div class = "indented">
                                        
                                        <asp:Panel runat = "server" ID = "Inner1" BorderStyle = "Dashed" BorderWidth = "1px">
                                        <asp:CheckBoxList ID = "WorkflowType" runat = "server">
                                            <asp:ListItem Text = "For Biomonitoring" Value = "3"></asp:ListItem> 
                                            <asp:ListItem Text = "For Fragment Analysis" Value = "4"></asp:ListItem>
                                            <%--<asp:ListItem Text = "For Consultation" Value = "5"></asp:ListItem>--%>
                                        
                                        </asp:CheckBoxList> 
                                        </asp:Panel>
                                </div>
                                <br />
                                <asp:Panel BorderWidth = "0px" runat = "server" ID = "NoActionPanel">
                                <asp:RadioButton ID = "Third" Text = "Accepted  No Action Required" GroupName = "Workflow" runat = "server" 
                                    Font-Bold = "false" />
                                </asp:Panel>     
                                <br />
                                <asp:Panel BorderWidth = "0px" runat = "server" ID = "IneligiblePanel">
                                    <asp:RadioButton ID = "Second" Text = "Ineligible" GroupName = "Workflow" runat = "server" 
                                        Font-Bold = "false" />
                                    <div class = "indented">
                                        <asp:Panel runat = "server" ID = "Inner2" BorderStyle = "Dashed" BorderWidth = "1px">
                                            <div style= "padding-left:10;padding-top:10;padding-bottom:10;font-size:medium;font-style:normal;font-size:small;">
                                                <asp:Label SkinID="DataLabel" ID = "LabelReason" runat = "server" 
                                                    Text = "Ineligibility Reason" 
                                                    AssociatedControlID="TextIneligibleReason">
                                                </asp:Label>
                                                <asp:TextBox ID = "TextIneligibleReason" runat = "server" 
                                                    TabIndex="6" 
                                                    Width = "600">
                                                </asp:TextBox>
                                                <asp:RequiredFieldValidator ID="IneligibleReasonValidator" runat="server" 
                                                    TabIndex="7"  
                                                    Display="Static" 
                                                    ControlToValidate="TextIneligibleReason" 
                                                    ErrorMessage="Ineligible Reason is required." 
                                                    SetFocusOnError="true" 
                                                    Enabled="false"
                                                    ValidationGroup="WorkflowsAndIneligible"/>
                                            </div> 
                                        </asp:Panel>
                                    </div>
                                </asp:Panel> 
                                <br />
                    </asp:Panel>
               </asp:Panel> 
               <br />
        </td>        
        </tr>
        <tr>
        <td>
            <asp:Panel runat = "server" ID = "Buttons" BorderStyle = "Solid" BorderWidth = "1px" Width = "100%" Font-Bold = "false"> 
                <div class = "indented">        
                <asp:Button ID="ButtonSave" runat="server" 
                    Enabled="true" 
                    ValidationGroup="WorkflowsAndIneligible"
                    Width="90px" 
                    TabIndex="8"  
                    OnClick="OKButton_Click"  
                    Visible="false"
                    Text="Save" />
        
                <asp:Button ID="OKButton" runat="server" 
                    Enabled="true" 
                    ValidationGroup="WorkflowsAndIneligible" 
                    Width="90px" 
                    TabIndex="9"  
                    Text="Save"   
                    OnClick="OKButton_Click" 
                    CausesValidation="true"/>
                <asp:Button ID = "CancelButton" Text = "Cancel" runat = "server" OnClick = "CancelButton_Click" Width = "90px" UseSubmitBehavior = "false" CssClass = "cancel" ValidationGroup = "CancelButton" />
                <asp:Button ID = "AddContactButton" CausesValidation="true" Text = "Add Contact" runat = "server" OnClick = "AddContact_Click" Width = "90px" UseSubmitBehavior= "false" />   
                               
                </div>    
                    <asp:CustomValidator id="OKButtonValidator" runat="server" 
                        Display="None" EnableClientScript="False"></asp:CustomValidator>
            </asp:Panel> 
        </td>
        </tr>
    </table> 
</asp:Content>
